<?php //adcafca8dff5f2be4dbfc5933b39b578
/** @noinspection all */

namespace App\Models {

    use Database\Factories\UserFactory;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\BelongsToMany;
    use Illuminate\Database\Eloquent\Relations\MorphToMany;
    use Illuminate\Notifications\DatabaseNotification;
    use Illuminate\Notifications\DatabaseNotificationCollection;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\App\Models\_IH_Category_C;
    use LaravelIdea\Helper\App\Models\_IH_Category_QB;
    use LaravelIdea\Helper\App\Models\_IH_Manager_C;
    use LaravelIdea\Helper\App\Models\_IH_Manager_QB;
    use LaravelIdea\Helper\App\Models\_IH_MenuItem_C;
    use LaravelIdea\Helper\App\Models\_IH_MenuItem_QB;
    use LaravelIdea\Helper\App\Models\_IH_Restaurant_C;
    use LaravelIdea\Helper\App\Models\_IH_Restaurant_QB;
    use LaravelIdea\Helper\App\Models\_IH_User_C;
    use LaravelIdea\Helper\App\Models\_IH_User_QB;
    use LaravelIdea\Helper\Illuminate\Notifications\_IH_DatabaseNotification_QB;
    use LaravelIdea\Helper\Spatie\MediaLibrary\MediaCollections\Models\_IH_Media_QB;
    use LaravelIdea\Helper\Spatie\Permission\Models\_IH_Permission_C;
    use LaravelIdea\Helper\Spatie\Permission\Models\_IH_Permission_QB;
    use LaravelIdea\Helper\Spatie\Permission\Models\_IH_Role_C;
    use LaravelIdea\Helper\Spatie\Permission\Models\_IH_Role_QB;
    use Spatie\MediaLibrary\MediaCollections\Models\Collections\MediaCollection;
    use Spatie\MediaLibrary\MediaCollections\Models\Media;
    use Spatie\Permission\Models\Permission;
    use Spatie\Permission\Models\Role;

    /**
     * @property int $id
     * @property string $name
     * @property int $restaurant_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Carbon|null $deleted_at
     * @method static _IH_Category_QB onWriteConnection()
     * @method _IH_Category_QB newQuery()
     * @method static _IH_Category_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Category_QB query()
     * @method static _IH_Category_QB with(array|string $relations)
     * @method _IH_Category_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Category_C|Category[] all($columns = ['*'])
     * @ownLinks restaurant_id,\App\Models\Restaurant,id
     * @foreignLinks id,\App\Models\MenuItem,category_id
     * @mixin _IH_Category_QB
     */
    class Category extends Model {}

    /**
     * @property int $id
     * @property int $user_id
     * @property int $restaurant_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Manager_QB onWriteConnection()
     * @method _IH_Manager_QB newQuery()
     * @method static _IH_Manager_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Manager_QB query()
     * @method static _IH_Manager_QB with(array|string $relations)
     * @method _IH_Manager_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Manager_C|Manager[] all($columns = ['*'])
     * @ownLinks user_id,\App\Models\User,id|restaurant_id,\App\Models\Restaurant,id
     * @mixin _IH_Manager_QB
     */
    class Manager extends Model {}

    /**
     * @property int $id
     * @property int $category_id
     * @property int $restaurant_id
     * @property string $name
     * @property string|null $description
     * @property float $price
     * @property int|null $preparation_time Preparation time in minutes
     * @property int $is_available
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Carbon|null $deleted_at
     * @property int $spicy_level Spicy level from 0 (not spicy) to 5 (very spicy)
     * @property Category $category
     * @method BelongsTo|_IH_Category_QB category()
     * @property MediaCollection|Media[] $media
     * @property-read int $media_count
     * @method MorphToMany|_IH_Media_QB media()
     * @property Restaurant $restaurant
     * @method BelongsTo|_IH_Restaurant_QB restaurant()
     * @method static _IH_MenuItem_QB onWriteConnection()
     * @method _IH_MenuItem_QB newQuery()
     * @method static _IH_MenuItem_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_MenuItem_QB query()
     * @method static _IH_MenuItem_QB with(array|string $relations)
     * @method _IH_MenuItem_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_MenuItem_C|MenuItem[] all($columns = ['*'])
     * @ownLinks category_id,\App\Models\Category,id|restaurant_id,\App\Models\Restaurant,id
     * @mixin _IH_MenuItem_QB
     */
    class MenuItem extends Model {}

    /**
     * @property int $id
     * @property string $name
     * @property int $is_active
     * @property int $user_id
     * @property Carbon|null $deleted_at
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_Restaurant_QB onWriteConnection()
     * @method _IH_Restaurant_QB newQuery()
     * @method static _IH_Restaurant_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Restaurant_QB query()
     * @method static _IH_Restaurant_QB with(array|string $relations)
     * @method _IH_Restaurant_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Restaurant_C|Restaurant[] all($columns = ['*'])
     * @ownLinks user_id,\App\Models\User,id
     * @foreignLinks id,\App\Models\Category,restaurant_id|id,\App\Models\MenuItem,restaurant_id|id,\App\Models\Manager,restaurant_id
     * @mixin _IH_Restaurant_QB
     */
    class Restaurant extends Model {}

    /**
     * @property int $id
     * @property string $name
     * @property string $email
     * @property Carbon|null $email_verified_at
     * @property mixed $password
     * @property string|null $remember_token
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string|null $two_factor_secret
     * @property string|null $two_factor_recovery_codes
     * @property Carbon|null $two_factor_confirmed_at
     * @property DatabaseNotificationCollection|DatabaseNotification[] $notifications
     * @property-read int $notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB notifications()
     * @property _IH_Permission_C|Permission[] $permissions
     * @property-read int $permissions_count
     * @method MorphToMany|_IH_Permission_QB permissions()
     * @property DatabaseNotificationCollection|DatabaseNotification[] $readNotifications
     * @property-read int $read_notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB readNotifications()
     * @property _IH_Restaurant_C|Restaurant[] $restaurants
     * @property-read int $restaurants_count
     * @method BelongsToMany|_IH_Restaurant_QB restaurants()
     * @property _IH_Role_C|Role[] $roles
     * @property-read int $roles_count
     * @method MorphToMany|_IH_Role_QB roles()
     * @property DatabaseNotificationCollection|DatabaseNotification[] $unreadNotifications
     * @property-read int $unread_notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB unreadNotifications()
     * @method static _IH_User_QB onWriteConnection()
     * @method _IH_User_QB newQuery()
     * @method static _IH_User_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_User_QB query()
     * @method static _IH_User_QB with(array|string $relations)
     * @method _IH_User_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_User_C|User[] all($columns = ['*'])
     * @foreignLinks id,\App\Models\Restaurant,user_id|id,\App\Models\Manager,user_id
     * @mixin _IH_User_QB
     * @method static UserFactory factory(callable|int|mixed[]|null $count = null, callable|mixed[] $state = [])
     */
    class User extends Model {}
}
